from sympy import Poly
from sympy.abc import x, y, z
import numpy as np

X_function = 0.1*x+0.2*y+0.3*z+10000
Y_function = 0.2*x +0.1*y+0.2*z+15000
Z_function = 0.1*x+0.5*y+0.3*z+13000

p = Poly(X_function, x, y, z)
k = Poly(Y_function, x, y, z)
s = Poly(Z_function, x, y, z)

X_function_x = p.coeff_monomial(x)
X_function_y = p.coeff_monomial(y)
X_function_z = p.coeff_monomial(z)

Y_function_x = k.coeff_monomial(x)
Y_function_y = k.coeff_monomial(y)
Y_function_z = k.coeff_monomial(z)

Z_function_x = s.coeff_monomial(x)
Z_function_y = s.coeff_monomial(y)
Z_function_z = s.coeff_monomial(z)

M = np.array([
    [float(X_function_x), float(X_function_y), float(X_function_z)],
    [float(Y_function_x), float(Y_function_y), float(Y_function_z)],
    [float(Z_function_x), float(Z_function_y), float(Z_function_z)]
    ])

D = np.array([float(p.nth(0, 0, 0)), float(k.nth(0, 0, 0)), float(s.nth(0, 0, 0))])


I = np.identity(3)
matrix = I-M

sols = np.linalg.solve(matrix, D)

print('To meet both the internal and consumer demands, the merchant must have an output of $', sols[0],
      'the backer must have an output of $', sols[1], 'and the farmer must have an output of $', sols[2])

