from sympy import Poly, Symbol, solve_poly_inequality
from sympy.solvers.inequalities import solve_poly_inequalities

Q=Symbol('Q')
cost=Q**3-10*Q**2+30*Q+3550
constraint_max=10000
constraint_min=6000

cost_max = cost - constraint_max
cost_min = cost - constraint_min

p = Poly(cost_max, Q)
z = Poly(cost_min, Q)

k = solve_poly_inequality(p, '<')
s = solve_poly_inequality(z, '>')

x_1 = s[0].evalf()
x_2 = k[0].evalf()

production = x_1.intersect(x_2)
x, y = production.boundary

print('Within the given constraints, the production should be in the following range:', '%.2f' % x, '< Q <', '%.2f'% y)

from pylab import plot, show
from sympy.utilities.lambdify import lambdify
from sympy import Symbol
import numpy as np
import matplotlib.pyplot as plt

Q=Symbol('Q')
cost=Q**3-10*Q**2+30*Q+3550
evalcost_function = lambdify(Q, cost, modules=['numpy'])
t = np.linspace(0, 25, 100)
plt.plot(t, evalcost_function(t), color='r', label='Cost function')


plt.axhline(y=constraint_min, color='k', linewidth=0.05)
plt.axhline(y=constraint_max, color='k', linewidth=0.05)
plt.axhline(y=3000, color='k', linewidth=0.2)

plt.plot((x, x), (3000, constraint_min), color='k', linewidth=0.5, linestyle='--')
plt.plot((y, y), (3000, constraint_max), color='k', linewidth=0.5, linestyle='--')

plt.text(19.4, 4500, r"$16.85<Q<21.98$",
           horizontalalignment='center', fontsize=7)
plt.text(19.4, 5000, r"$Production$",
           horizontalalignment='center', fontsize=7)

plt.xlabel('Q')
plt.ylabel('Cost')

plt.show()