from sympy import Poly
from sympy.abc import x, y, A
import sympy as sp
import numpy as np

lagrangian_function=5*x**2 + 8*y**2 - x*y + 50 + A*28 - A*x - A*y
expr1=sp.diff(lagrangian_function, x)
expr2=sp.diff(lagrangian_function, y)
expr3=sp.diff(lagrangian_function, A)

p = Poly(expr1, x, y, A)
k = Poly(expr2, x, y, A)
s = Poly(expr3, x, y, A)

expr1_x = p.coeff_monomial(x)
expr1_y = p.coeff_monomial(y)
expr1_A = p.coeff_monomial(A)

expr2_x = k.coeff_monomial(x)
expr2_y = k.coeff_monomial(y)
expr2_A = k.coeff_monomial(A)

expr3_x = s.coeff_monomial(x)
expr3_y = s.coeff_monomial(y)
expr3_A = s.coeff_monomial(A)

C = np.array([
    [float(expr1_x), float(expr1_y), float(expr1_A)],
    [float(expr2_x), float(expr2_y), float(expr2_A)],
    [float(expr3_x), float(expr3_y), float(expr3_A)]
    ])

B = np.array([-float(p.nth(0, 0, 0)), -float(k.nth(0, 0, 0)), -float(s.nth(0, 0, 0))])

sols = np.linalg.solve(C, B)

x_good, y_good, A_lambda = sols

cost_function=5*x**2 + 8*y**2 + x*y + 50
cost_min=cost_function.subs([(x, x_good), (y, y_good)])

print('The following combination of goods minimizes the costs: x=', x_good, 'y=', y_good)
print('This combination of goods will minimize costs to the level of:', '%.2f' % cost_min)
print('Interpretation of lambda: a decrease in the production quota will lead to a cost reduction of', A_lambda)
