from sympy import Symbol
import sympy as sp

Q = Symbol('Q')
total_cost_function = 3550 + 30*Q - 10*Q**2 + Q**3
total_revenue_function = 600*Q
profit = total_revenue_function - total_cost_function
expr1=sp.diff(profit,Q)

sols = sp.solve(expr1)
for x in sols:
    if x > 0:
       res = x
k = profit.subs(Q, res)
print('Profit is maximized at Q =', '%.2f' % float(res), 'where profit equals', '%.2f' % float(k))

from sympy import Poly
from sympy.utilities.lambdify import lambdify
import matplotlib.pyplot as plt
import numpy as np

p = Poly(total_revenue_function, Q)
a = p.coeff_monomial(Q)

y = total_cost_function.subs(Q, res)

tangent = a*Q - a*res + y
evaltotal_cost_function = lambdify(Q, total_cost_function, modules=['numpy'])
evaltotal_revenue_function = lambdify(Q, total_revenue_function, modules=['numpy'])
evaltangent = lambdify(Q, tangent, modules=['numpy'])

t = np.linspace(0, 30, 100)
plt.plot(t, evaltotal_cost_function(t), color='r', label='Total cost')
plt.plot(t, evaltotal_revenue_function(t), color='b', label='Total revenue')
plt.plot(t, evaltangent(t), color='b', linestyle='--', label='Tangent to TC')
plt.fill_between(
    t, evaltotal_cost_function(t), evaltotal_revenue_function(t),
    where=evaltotal_cost_function(t) < evaltotal_revenue_function(t),
    facecolor='yellow', hatch="o", label='Profit')

plt.plot((res, res), (0, y), color='r', linestyle='--')
plt.axhline(y=0, color='k', linewidth=0.2)
plt.text(res, -900, r"$Q_0$", horizontalalignment='center', verticalalignment='center', fontsize=12)

plt.xlabel('Q')
plt.ylabel('Cost, Revenue in $')
plt.legend(loc='best')

plt.show()
