from sympy import Symbol
import sympy as sp
from sympy import solve, re

Q = Symbol('Q')
total_cost_function = 3550 + 30*Q - 10*Q**2 + Q**3
total_revenue_function = 600*Q
profit = total_cost_function - total_revenue_function
sols=sp.solve(profit)

endpoints = [ ]
for x in sols:
    endpoint = float(re(x))
    if endpoint >=0:
        endpoints.append(endpoint)
ep1, ep2 = sorted(endpoints)

profit = sp.integrate(total_revenue_function, (Q, ep1, ep2)) - sp.integrate(total_cost_function, (Q, ep1, ep2))
print('Profit equals:', '%.2f' % (profit))

from pylab import plot, show
from sympy.utilities.lambdify import lambdify
from sympy import Symbol
import numpy as np
import matplotlib.pyplot as plt

Q = Symbol('Q')
total_cost_function = 3550 + 30*Q - 10*Q**2 + Q**3
evaltotal_cost_function = lambdify(Q, total_cost_function, modules=['numpy'])
evaltotal_revenue_function = lambdify(Q, total_revenue_function, modules=['numpy'])
t = np.linspace(0, 30, 100)
plt.plot(t, evaltotal_cost_function(t), color='r', label='Total cost')
plt.plot(t, evaltotal_revenue_function(t), color='b', label='Total revenue')

plt.fill_between( t, evaltotal_cost_function(t), evaltotal_revenue_function(t),
    where=evaltotal_cost_function(t) < evaltotal_revenue_function(t),
                  facecolor='yellow', hatch="o", label='Profit')

plt.xlabel('Q')
plt.ylabel('Cost, Revenue in $')
plt.legend(loc='best')

plt.show()