import sympy as sp
from sympy import Symbol

Q = Symbol('Q')
supply_function = Q**2+Q+10
P0 = 30
equilibrium = supply_function - P0
sols = sp.solve(equilibrium, dict=True)
for x in sols:
    if x[Q] > 0:
        res = x[Q]
print('Q0 equals:', float(res))
producers_surplus = res * P0 - sp.integrate(supply_function, (Q, 0, res))
print('Producers\' surplus equals:', float(producers_surplus))

import matplotlib
matplotlib.use('TkAgg')

from sympy.utilities.lambdify import lambdify
import numpy as np
import matplotlib.pyplot as plt
from pylab import title
from sympy import Symbol


Q = Symbol('Q')
supply_function = Q**2+Q+10
evalsupply_function = lambdify(Q, supply_function, modules=['numpy'])
plt.plot((0, 4.5), (P0, P0), color='r', linestyle='--')
plt.plot((res, res), (35, 0), color='r', linestyle='--')
t = np.linspace(0, P0, 100)
plt.plot(t, evalsupply_function(t), color='b', linestyle='-', label='demand function f(Q)')
ht = np.linspace(0, 4, 100)
plt.fill_between(ht, P0, evalsupply_function(ht), facecolor='yellow', label='producers surplus',  hatch="//")
title('Producers\' surplus')
plt.xlim(0, 6)
plt.ylim(0, 55)
plt.show()

