from sympy import Symbol
import sympy as sp
from sympy import solve

Q = Symbol('Q')
demand_function = 46 - 3*Q - Q**2
P0 = 6
equilibrum=demand_function - P0
sols=sp.solve(equilibrum, dict=True)

for x in sols:
  if x[Q] > 0:
    res = x[Q]

consumers_surplus = sp.integrate(demand_function, (Q, 0, res)) - res * P0

print('Consumers\' surplus equals:', float(consumers_surplus))

import matplotlib
matplotlib.use('TkAgg')
from pylab import plot, show
from sympy.utilities.lambdify import lambdify
from sympy import Symbol
import numpy as np
import matplotlib.pyplot as plt

Q = Symbol('Q')
demand_function = 46 - 3*Q - Q**2
evaldemand_function = lambdify(Q, demand_function, modules=['numpy'])
plt.plot((0, 5.5), (P0, P0), color='r', linestyle='--')
plt.plot((res, res), (15, 0), color='r', linestyle='--')
t = np.linspace(0, P0, 100)
plt.plot(t, evaldemand_function(t), color='b', linestyle='-', label='demand function f(Q)')

ht = np.linspace(0, 5, 100)
plt.fill_between(ht, 6, evaldemand_function(ht), facecolor='yellow', label='consumers surplus')

plt.text(1, 20, r"$\int_0^5 f(Q)\mathrm{d}Q$$-(4)(5)$",
           horizontalalignment='center', fontsize=10)
plt.text(-0.2, 6, r"$P_0$", horizontalalignment='center', verticalalignment='center', fontsize=12)
plt.text(5, -2.2, r"$Q_0$", horizontalalignment='center',verticalalignment='center', fontsize=12)
plt.legend(loc='best')
plt.axhline(y=0, color='k', linewidth=0.2)
plt.axvline(x=0, color='k')
plt.xlim(0, 7)
data_x= [5]
data_y= [6]
plt.plot(data_x, data_y, 'or')
plt.xlabel('Q')
plt.ylabel('Price')

plt.show()